import { API_URL, BACKEND_URL, POST_COMPONENT_TYPE } from './pages.constants';
import { convertXLtoJSON } from './helpers';
export const getAllPages = async () => {
	try {
		const pathsData = (await (await fetch(`${API_URL}/api/pages`)).json()).data;
		return pathsData;
	} catch (error) {
		console.log(error);
		return [];
	}
};

const setImagesPath = (posts) => {
	posts.forEach((post) => {
		if (post.image?.url) post.image.url = BACKEND_URL + post.image.url;
		post.type?.forEach((type) => {
			if (type.__component === POST_COMPONENT_TYPE.DOCUMENT && type.file?.url) {
				type.file.url = BACKEND_URL + type.file.url;
			} else if (
				type.__component === POST_COMPONENT_TYPE.IMAGE &&
				type.image?.url
			) {
				type.image.url = BACKEND_URL + type.image.url;
			}
		});
	});
};

const setPageImagePath = (posts) => {
	posts.forEach((post) => {
		if (!post.attributes.image.data) return;
		let url = BACKEND_URL + post.attributes.image.data.attributes.url;
		post.attributes.image.url = url;
	});
};

export const getPageData = async (pageId) => {
	const pagePostData = (
		await (await fetch(`${API_URL}/api/pages/${pageId}`)).json()
	).data.attributes;
	setPageImagePath(pagePostData.posts.data);

	return pagePostData;
};
export const getHeaderFooterData = async () => {
	try {
		const headerFooterData = await (
			await fetch(`${API_URL}/api/header-footer`)
		).json();
		if (headerFooterData.tickingHeader)
			headerFooterData.tickingHeader.logo.url =
				BACKEND_URL + headerFooterData.tickingHeader.logo.url;

		if (headerFooterData.footerPost)
			setImagesPath([headerFooterData.footerPost]);

		return headerFooterData;
	} catch (error) {
		console.log(error);
		return;
	}
};

export const getHomepageData = async () => {
	try {
		const homepageData = await (await fetch(`${API_URL}/api/home`)).json();

		if (homepageData.featuredPost) setImagesPath([homepageData.featuredPost]);
		setImagesPath(homepageData.leftTrending.results);
		setImagesPath(homepageData.rightTrending.results);
		setImagesPath(homepageData.body.results);

		return homepageData;
	} catch (error) {
		console.log(error);
		return [];
	}
};

export const getResources = async () => {
	try {
		const resources = (
			await (await fetch(`${API_URL}/api/resource-page`)).json()
		)?.data?.attributes;

		return resources;
	} catch (error) {
		console.log(error);
		return [];
	}
};

export const getContactData = async () => {
	try {
		const contactData = (
			await (await fetch(`${API_URL}/api/contact-page`)).json()
		).data.attributes;

		return contactData;
	} catch (error) {
		console.log(error);
		return [];
	}
};

export const getToolsData = async () => {
	try {
		const topicsData = await (
			await fetch(`${API_URL}/api/tools?sort=createdAt:desc`)
		).json();
		return topicsData;
	} catch (error) {
		console.log(error);
		return [];
	}
};

export const getBookmarkssData = async () => {
	try {
		const topicsData = await (
			await fetch(`${API_URL}/api/bookmarks?sort=createdAt:desc`)
		).json();

		return topicsData;
	} catch (error) {
		console.log(error);
		return [];
	}
};

export const getCarpetBombsData = async () => {
	try {
		const topicsData = await (
			await fetch(`${API_URL}/api/carpet-bombs?sort=createdAt:desc`)
		).json();

		let completeRssFeed = topicsData;
		const rssPromises = [];

		for (let i = 0; i < topicsData.data.length; i++) {
			for (let j = 0; j < topicsData.data[i].attributes.level_2.length; j++) {
				for (
					let k = 0;
					k < topicsData.data[i].attributes.level_2[j].links.length;
					k++
				) {
					const link = topicsData.data[i].attributes.level_2[j].links[k];
					const rssPromise = getRssData(link.rss).then((rssData) => {
						completeRssFeed.data[i].attributes.level_2[j].links[k].rss =
							rssData;
					});
					rssPromises.push(rssPromise);
				}
			}
		}

		await Promise.all(rssPromises);

		return completeRssFeed;
	} catch (error) {
		console.log(error);
		return [];
	}
};

function groupByDate(data) {
	// Create an empty object to store the grouped data
	const groupedData = {};

	// Iterate over each item in the data array
	data.forEach((item) => {
		console.log(item);

		const date =
			item?.attributes?.date != null
				? item.attributes.date
				: item.attributes.publishedAt.split('T')[0];

		// If the date does not exist in the groupedData object, create a new array for it
		if (!groupedData[date]) {
			groupedData[date] = [];
		}

		// Push the current item to the array corresponding to its date
		groupedData[date].push(item);
	});

	// Convert the grouped data object into an array of objects with date and items properties
	const result = Object.keys(groupedData).map((date) => ({
		date: date,
		items: groupedData[date],
	}));

	return result;
}

export const getExclusiveData = async (page = 1) => {
	try {
		const topicsData = await (
			await fetch(
				`${API_URL}/api/exclusives?pagination[page]=${page}&sort=publishedAt:desc`
			)
		).json();

		return groupByDate(topicsData?.data);
	} catch (error) {
		console.log(error);
		return [];
	}
};

export const getExclusiveUnformatedData = async () => {
	try {
		const topicsData = await (await fetch(`${API_URL}/api/exclusives`)).json();

		return topicsData;
	} catch (error) {
		console.log(error);
		return [];
	}
};

export const getExclusivePostBySlug = async (slug) => {
	try {
		const exclusive = await (
			await fetch(
				`${API_URL}/api/slugify/slugs/exclusive/${slug}?populate[0]=content.image&populate[1]=content.file`
			)
		).json();


		return exclusive;
	} catch (error) {
		console.log(error);
		return { data: [] };
	}
};

export const getConfigData = async () => {
	try {
		const configData = await (await fetch(`${API_URL}/api/page-config`)).json();

		return configData;
	} catch (error) {
		console.log(error);
		return [];
	}
};

export const getRssData = async (rssLink) => {
	try {
		const rssXML = await (await fetch(rssLink)).text();
		const rssJson = await convertXLtoJSON(rssXML);
		return rssJson;
	} catch (error) {
		console.log(error);
		return [];
	}
};
