import xml2js from 'xml2js'
export const classNames = (...classes) => {
	return classes.filter(Boolean).join(' ');
};

// a function to split an array into 3 subarrays of equal length (or as close as possible) and return them in an array of arrays
export const splitArray = (array) => {
	const arrayLength = array.length;
	const splitArray = [];
	let i = 0;
	while (i < arrayLength) {
		splitArray.push(array.slice(i, i + Math.ceil(arrayLength / 3)));
		i += Math.ceil(arrayLength / 3);
	}
	return splitArray;
};



export const paginate = (items, pageNumber, pageSize) => {
	const startIndex = (pageNumber - 1) * pageSize;
	return items.slice(startIndex, startIndex + pageSize);
};


export const convertXLtoJSON = async (xml) => {

	const xmlToJson = await xml2js.parseStringPromise(xml)
		.catch(e => { throw e })
		.then(r => JSON.stringify(r, null, 4))

	return JSON.parse(xmlToJson);
}


export const formatDate = (dateString) => {
	const date = new Date(dateString);
	const year = date.getFullYear();
	const month = String(date.getMonth() + 1).padStart(2, '0'); // Months are 0-based
	const day = String(date.getDate()).padStart(2, '0');
	return `${year}-${month}-${day}`;
}