import styles from '../styles/Home.module.css';
import Head from 'next/head';
import PageLayout from '../components/PageLayout';
import { getHeaderFooterData, getResources } from '../utils/pages.data';
import { useState } from 'react';
import Script from 'next/script';

export const getStaticProps = async () => {
	const resources = await getResources();
	const header_data = await getHeaderFooterData();

	return {
		props: {
			topics: resources.topics?.data ? resources.topics.data : [],
			...header_data,
		},
		revalidate: 1,
	};
};
const Resources = ({
	topics = [],
	header,
	footerPost,
	footerContacts,
}) => {
	const [selectedTopic, setSelectedTopic] = useState(0);

	const onSelectedHandler = (e) => {
		setSelectedTopic(e.target.value);
	};

	return (
		<div className={styles.container}>
			<Head>
				<title>Resources | Ticking Bomb</title>
				<meta name='description' content='Generated by create next app' />
				<link rel='icon' href='/favicon.png' />
			</Head>
			<Script
				async
				src='https://www.googletagmanager.com/gtag/js?id=G-FYX6YCNCL5'
			></Script>
			<Script id='gtag-cont'>
				{`
						window.dataLayer = window.dataLayer || [];
						function gtag(){dataLayer.push(arguments);}
						gtag('js', new Date());

						gtag('config', 'G-FYX6YCNCL5');
					`}
			</Script>
			<PageLayout
				className='lg:px-14'
				pageTitle='Resources'
				header={header}
				footerPost={footerPost}
				footerContacts={footerContacts}
			>
				<section className='flex flex-col lg:flex-row justify-between w-full mt-7'>
					<div className='bg-template-bg-grey w-full lg:w-72 text-left p-3'>
						<h2 className='font-bold text-lg pb-3'>Explore all topics</h2>
						<div>
							{topics?.map((topic, index) => (
								<button
									key={topic.id}
									value={index}
									className='list-none p-2 cursor-pointer hover:bg-template-input-border w-full text-left'
									onClick={onSelectedHandler}
								>
									{topic.attributes.name}
								</button>
							))}
						</div>
					</div>
					<div className='flex-1 text-center'>
						{/* Sections */}
						{topics[selectedTopic] &&
							topics[selectedTopic].attributes.Section?.map((section) => (
								<div className='mb-4' key={section.id}>
									<h2 className='text-lg pb-3 font-semibold'>
										{section.title}
									</h2>
									<ul>
										{section.links?.map((link) => (
											<li className='list-none pb-2' key={link.id}>
												<a
													href={link.url + '?utm_source=tickingbomb.com'}
													target='_blank'
													rel='noopener noreferrer'
												>
													{link.name}
												</a>
											</li>
										))}
									</ul>
								</div>
							))}
					</div>
					<div className='w-full lg:w-72 p-6 bg-template-bg-grey flex justify-center items-center text-gray-600'>
						Ad
					</div>
				</section>
			</PageLayout>
		</div>
	);
};

export default Resources;
