import styles from '../styles/Home.module.css';
import Head from 'next/head';
import PageLayout from '../components/PageLayout';
import { getConfigData, getContactData, getHeaderFooterData } from '../utils/pages.data';
import Post from '../components/Post';

export const getStaticProps = async () => {
	const header_data = await getHeaderFooterData();
	const configData = await getConfigData();
	const contact_data = await getContactData();
	return {
		props: {
			configData: configData ? configData?.data : {},
			...header_data,
			contact_data,
		},
		revalidate: 1,
	};
};
const Contact = ({
	tickingHeader,
	configData,
	footerPost,
	footerContacts,
}) => {
	

	return (
		<div className={styles.container}>
			<Head>
				<title>Hidden | Ticking Bomb</title>
				<meta name='description' content='Generated by create next app' />
				<link rel='icon' href='/logo.png' />
			</Head>
			<PageLayout
				pageTitle='CHECK BACK SOON'
				tickingHeader={tickingHeader}
				footerPost={footerPost}
				footerContacts={footerContacts}
			>
				<div className='flex justify-center'>
					<Post post={{type: configData?.attributes?.hidden_page, show_title: false}} />
				</div>
			</PageLayout>
		</div>
	);
};

export default Contact;
