import styles from '../styles/Home.module.css';
import PageLayout from '../components/PageLayout';
import {
	getHeaderFooterData,
	getBookmarkssData,
	getConfigData,
} from '../utils/pages.data';

import ThreeLevelNesting from '../components/ThreeLevelNesting';
import MetaHeader from '../components/MetaHeader';

export const getStaticProps = async () => {
	const bookmarksData = await getBookmarkssData();
	const configData = await getConfigData();

	const header_data = await getHeaderFooterData();

	return {
		props: {
			bookmarks: bookmarksData ? bookmarksData.data : [],
			configData: configData ? configData.data : {},

			...header_data,
		},
		revalidate: 1,
	};
};
const Bookmarks = ({
	bookmarks = [],
	configData,
	tickingHeader,
	footerPost,
	footerContacts,
}) => {
	return (
		<div className={styles.container}>
			<MetaHeader title='Bookmarks | Ticking Bomb' />
			<PageLayout
				className='lg:px-14'
				pageTitle='Bookmarks'
				tickingHeader={tickingHeader}
				configUrl={
					configData?.attributes?.bookmarks_logo?.data?.attributes?.url
				}
				footerPost={footerPost}
				footerContacts={footerContacts}
			>
				<div className='flex flex-col items-center w-full'>
					<p className='text-lg'>
						{configData?.attributes?.bookmarks_description}
					</p>
				</div>
				<ThreeLevelNesting topics={bookmarks} />
			</PageLayout>
		</div>
	);
};

export default Bookmarks;
