import { classNames } from '../utils/helpers';

const Tweet = ({ data, isFeatured }) => {
	return (
		<div
			className={classNames(
				'flex flex-col',
				isFeatured ? 'items-center' : 'items-start'
			)}
			style={{ width: `${data.img_size}%`, height: 'auto' }}
		>
			<h3
				className={`${data.title_emphasis ? 'font-bold' : ''}`}
				style={{
					color: data.hex_color,
					fontSize: `${data.text_size}rem`,
				}}
			>
				{data.title}
			</h3>
			<blockquote className='twitter-tweet'>
				<a href={data.url}></a>
			</blockquote>
			<script async src='https://platform.twitter.com/widgets.js'></script>
		</div>
	);
};

Tweet.defaultProps = {
	data: {
		title: '',
		url: '',
		img_size: 100,
		emphasis: false,
		hex_color: '#000000',
		text_size: 1,
	},
	isFeatured: false,
};
export default Tweet;
