import NewsColumn from './NewsColumn';

const TrendingNews = ({ title, leftTrending, rightTrending }) => {
	return (
		<section className='mt-5'>
			<h2 className='py-2 text-2xl font-bold text-white bg-black uppercase text-center'>
				{title}
			</h2>
			<div className='block lg:flex pt-3'>
				<NewsColumn posts={leftTrending.results} />
				<NewsColumn posts={rightTrending.results} isLast={true} />
			</div>
		</section>
	);
};
TrendingNews.defaultProps = {
	title: '',
	leftTrending: { results: [] },
	rightTrending: { results: [] },
};

export default TrendingNews;
