import { classNames } from '../utils/helpers';

const TextLink = ({ data }) => {
	const maxMobileTextSize = data.text_size > 3 ? 'max-sm:!text-5xl' : '';
	return (
		<a
			className={classNames(
				'leading-none text-template-black visited:!text-[#878787] hover:underline',
				data.emphasis && 'font-bold',
				maxMobileTextSize
			)}
			href={data.url + '?utm_source=tickingbomb.com'}
			style={{
				color: data.hex_color,
				fontSize: `${data.text_size}rem`,
			}}
			target={`${data.new_tab ? '_blank' : '_self'}`}
			rel='noopener noreferrer'
			title={data.scroll_text}
		>
			{data.title}
		</a>
	);
};

TextLink.defaultProps = {
	data: {
		title: '',
		emphasis: false,
		url: '#',
		hex_color: '#000000',
		new_tab: false,
		text_size: 1,
		scroll_text: '',
	},
};

export default TextLink;
