const PagePost = ({ post, leftAlignment }) => {
	return (
		<div className='px-2'>
			<div
				className={`mt-1 flex flex-col ${
					leftAlignment ? 'items-start' : 'items-start lg:items-end'
				}`}
			>
				{post.image.data && (
					<img
						className='object-contain h-28'
						src={post.image.url}
						alt={post.image.data.attributes.alternativeText}
					/>
				)}
				{post.links &&
					post.links?.map((link) => (
						<li key={link.id} className='lg:list-none'>
							<a
								className={`hover:underline ${
									link.emphasis ? 'font-bold' : ''
								}`}
								href={link.url + '?utm_source=tickingbomb.com'}
								style={{ color: link.hex_color }}
								target={`${link.new_tab ? '_blank' : '_self'}`}
								rel='noopener noreferrer'
							>
								{link.title}
							</a>
						</li>
					))}
			</div>
			<hr className='mt-3' />
		</div>
	);
};

PagePost.defaultProps = {
	post: {},
	leftAlignment: true,
};

export default PagePost;
