import Footer from './Footer';
import Navbar from './Navbar';
import Link from 'next/link';
import { BACKEND_URL, PATHS } from '../utils/pages.constants';
import { classNames } from '../utils/helpers';
import { useEffect } from 'react';

const PageLayout = ({
	className,
	children,
	pageTitle,
	configUrl,
	tickingHeader,
	footerPost,
	footerContacts,
}) => {
	useEffect(() => {
		const tickingBombDates = {
			after_expiry_url: tickingHeader?.after_expiry_url,
			before_expiry_url: tickingHeader?.before_expiry_url,
		};
		localStorage.setItem(
			'TICKINGBOMB_TIMER_LINKS',
			JSON.stringify(tickingBombDates)
		);
	}, [tickingHeader?.after_expiry_url, tickingHeader?.before_expiry_url]);

	return (
		<div className={className}>
			<Navbar />
			<div className='flex flex-col items-center mb-10'>
				<div className='w-full lg:w-3/4 mt-10 md:mt-4 flex justify-center items-center'>
					<Link
						href={
							tickingHeader?.logo_url ? tickingHeader?.logo_url : PATHS.home
						}
					>
						<a>
							<img src={tickingHeader?.logo.url} alt='Logo' />
						</a>
					</Link>
				</div>
				<h2 className='text-4xl uppercase tracking-widest text-center'>
					{tickingHeader?.motto}
				</h2>
				{tickingHeader && (
					<div
						title={tickingHeader.text}
						className='w-full flex justify-center'
					>
						<iframe
							className={classNames(
								'w-full',
								tickingHeader.size === 2
									? 'max-w-2xl'
									: tickingHeader.size === 3
									? 'max-w-3xl'
									: 'max-w-4xl'
							)}
							src={`/ticking.html?date=${tickingHeader.date}`}
						></iframe>
					</div>
				)}
				{/* <h2 className='text-4xl uppercase tracking-widest text-center'>
					{tickingHeader?.motto}
				</h2> */}
			</div>
			{configUrl && (
				<div className='flex justify-center mb-10'>
					<img src={BACKEND_URL + configUrl} className={`w-44`} alt='config logo' />
				</div>
			)}
			{pageTitle && (
				<h1 className='py-2 text-2xl font-bold text-white bg-black uppercase text-center'>
					{pageTitle}
				</h1>
			)}
			{children}
			<Footer
				footerContacts={footerContacts?.results}
				footerPost={footerPost}
			/>
		</div>
	);
};

PageLayout.defaultProps = {
	className: '',
	pageTitle: '',
};

export default PageLayout;
