import React from 'react';
import { classNames } from '../utils/helpers';
import Post from './Post';

const NewsColumn = ({ posts, leftAlignment, startingIndex, isLast }) => {
	return (
		<div
			className={classNames(
				leftAlignment ? 'text-left' : 'lg:text-right',
				!isLast ? 'lg:border-r-2' : '',
				'flex-1'
			)}
		>
			{posts?.map((post, index) => {
				// if (startingIndex + index !== 0 && (startingIndex + index) % 2 === 0) {
				// 	return (
				// 		<React.Fragment key={post.id}>
				// 			<div className='h-52 flex justify-center items-center text-3xl text-white border border-black bg-gray-400'>
				// 				RESERVED
				// 			</div>
				// 			<Post post={post} leftAlignment={leftAlignment} />
				// 		</React.Fragment>
				// 	);
				// } else {
				return <Post post={post} key={post.id} leftAlignment={leftAlignment} />;
				// }
			})}
		</div>
	);
};

NewsColumn.defaultProps = {
	posts: [],
	leftAlignment: true,
	isLast: false,
	startingIndex: 0,
};

export default NewsColumn;
