import React from 'react';
import Head from 'next/head';
import Script from 'next/script';

function MetaHeader({
	title,
	ogTitle = 'TickingBomb - Explosive News Aggregator',
	ogDescription = 'Ticking Bomb brings you news from websites banned by big tech!',
	ogImage = '/logo.png',
}) {
	return (
		<>
			<Head>
				<title>{title}</title>
				<meta name='title' content={ogTitle} />
				<meta name='description' content={ogDescription} />
				<link rel='icon' href='/favicon.png' />
				<meta name='og:description' content={ogDescription} />
				<meta property='og:image' content={ogImage} />
			</Head>
			<Script
				async
				src='https://www.googletagmanager.com/gtag/js?id=G-FYX6YCNCL5'
			></Script>
			<Script id='gtag-cont'>
				{`
						window.dataLayer = window.dataLayer || [];
						function gtag(){dataLayer.push(arguments);}
						gtag('js', new Date());

						gtag('config', 'G-FYX6YCNCL5');
					`}
			</Script>
		</>
	);
}

export default MetaHeader;
