import Link from 'next/link';
import React from 'react';

const ExclusivePost = ({ post }) => {

	return (
		<>
			<div className='flex flex-row text-left justify-between gap-10 '>
				<div className='flex flex-col gap-5 justify-between'>
					<div className='flex flex-col gap-2'>
						<p className='text-5xl font-bold underline'>{post?.date}</p>
						<div className='flex flex-col gap-5'>
							{post?.items?.map((item,index) => (
								<div className='flex flex-col' key={index}>
									<Link href={`/exclusive/${item?.attributes?.slug}`}>
										<a className='text-2xl font-bold cursor-pointer hover:underline'>
											{item?.attributes?.title}
										</a>
									</Link>
									<a
										className='text-base hover:underline '
										href={
											item?.attributes?.author_url +
											'?utm_source=tickingbomb.com'
										}
										target='_blank'
										rel='noopener noreferrer'
									>
										{item?.attributes?.author}
									</a>
								</div>
							))}
						</div>
					</div>
				</div>
			</div>
			<div className='w-full h-0.5 bg-gray-200' />
		</>
	);
};

export default ExclusivePost;
