import React from 'react';
import { splitArray } from '../utils/helpers';
import NewsColumn from './NewsColumn';

const BodySection = ({ title, body }) => {
	const bodyColumnns = splitArray(body.results);
	return (
		<section className='my-5'>
			<h2 className='py-2 text-2xl text-white bg-black font-bold uppercase text-center'>
				{title}
			</h2>
			<div className='block lg:flex pt-3'>
				{bodyColumnns && bodyColumnns.length > 0 && (
					<>
						<NewsColumn posts={bodyColumnns[0]} />
						{bodyColumnns[1] && (
							<NewsColumn
								posts={bodyColumnns[1]}
								startingIndex={bodyColumnns[0].length}
							/>
						)}
						{bodyColumnns[2] && (
							<NewsColumn
								posts={bodyColumnns[2]}
								startingIndex={bodyColumnns[0].length + bodyColumnns[1].length}
								isLast={true}
							/>
						)}
					</>
				)}
			</div>
		</section>
	);
};

BodySection.defaultProps = {
	body: { results: [] },
};
export default BodySection;
