"use strict";
(() => {
var exports = {};
exports.id = 405;
exports.ids = [405];
exports.modules = {

/***/ 2301:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ pages),
  "getStaticProps": () => (/* binding */ getStaticProps)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
// EXTERNAL MODULE: external "next/head"
var head_ = __webpack_require__(968);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(6689);
// EXTERNAL MODULE: ./utils/helpers.js
var helpers = __webpack_require__(7278);
// EXTERNAL MODULE: ./components/Post.js
var Post = __webpack_require__(3517);
;// CONCATENATED MODULE: ./components/NewsColumn.js




const NewsColumn = ({ posts , leftAlignment , startingIndex , isLast  })=>{
    return /*#__PURE__*/ jsx_runtime_.jsx("div", {
        className: (0,helpers/* classNames */.AK)(leftAlignment ? "text-left" : "lg:text-right", !isLast ? "lg:border-r-2" : "", "flex-1"),
        children: posts?.map((post, index)=>{
            // if (startingIndex + index !== 0 && (startingIndex + index) % 2 === 0) {
            // 	return (
            // 		<React.Fragment key={post.id}>
            // 			<div className='h-52 flex justify-center items-center text-3xl text-white border border-black bg-gray-400'>
            // 				RESERVED
            // 			</div>
            // 			<Post post={post} leftAlignment={leftAlignment} />
            // 		</React.Fragment>
            // 	);
            // } else {
            return /*#__PURE__*/ jsx_runtime_.jsx(Post/* default */.Z, {
                post: post,
                leftAlignment: leftAlignment
            }, post.id);
        // }
        })
    });
};
NewsColumn.defaultProps = {
    posts: [],
    leftAlignment: true,
    isLast: false,
    startingIndex: 0
};
/* harmony default export */ const components_NewsColumn = (NewsColumn);

;// CONCATENATED MODULE: ./components/BodySection.js




const BodySection = ({ title , body  })=>{
    const bodyColumnns = (0,helpers/* splitArray */.C1)(body.results);
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("section", {
        className: "my-5",
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("h2", {
                className: "py-2 text-2xl text-white bg-black font-bold uppercase text-center",
                children: title
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: "block lg:flex pt-3",
                children: bodyColumnns && bodyColumnns.length > 0 && /*#__PURE__*/ (0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
                    children: [
                        /*#__PURE__*/ jsx_runtime_.jsx(components_NewsColumn, {
                            posts: bodyColumnns[0]
                        }),
                        bodyColumnns[1] && /*#__PURE__*/ jsx_runtime_.jsx(components_NewsColumn, {
                            posts: bodyColumnns[1],
                            startingIndex: bodyColumnns[0].length
                        }),
                        bodyColumnns[2] && /*#__PURE__*/ jsx_runtime_.jsx(components_NewsColumn, {
                            posts: bodyColumnns[2],
                            startingIndex: bodyColumnns[0].length + bodyColumnns[1].length,
                            isLast: true
                        })
                    ]
                })
            })
        ]
    });
};
BodySection.defaultProps = {
    body: {
        results: []
    }
};
/* harmony default export */ const components_BodySection = (BodySection);

// EXTERNAL MODULE: ./components/FeaturedPost.js
var FeaturedPost = __webpack_require__(1798);
;// CONCATENATED MODULE: ./components/TrendingNews.js


const TrendingNews = ({ title , leftTrending , rightTrending  })=>{
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("section", {
        className: "mt-5",
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("h2", {
                className: "py-2 text-2xl font-bold text-white bg-black uppercase text-center",
                children: title
            }),
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "block lg:flex pt-3",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx(components_NewsColumn, {
                        posts: leftTrending.results
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx(components_NewsColumn, {
                        posts: rightTrending.results,
                        isLast: true
                    })
                ]
            })
        ]
    });
};
TrendingNews.defaultProps = {
    title: "",
    leftTrending: {
        results: []
    },
    rightTrending: {
        results: []
    }
};
/* harmony default export */ const components_TrendingNews = (TrendingNews);

// EXTERNAL MODULE: ./styles/Home.module.css
var Home_module = __webpack_require__(9399);
var Home_module_default = /*#__PURE__*/__webpack_require__.n(Home_module);
// EXTERNAL MODULE: ./components/PageLayout.js + 20 modules
var PageLayout = __webpack_require__(1220);
// EXTERNAL MODULE: ./utils/pages.data.js
var pages_data = __webpack_require__(7324);
// EXTERNAL MODULE: external "next/script"
var script_ = __webpack_require__(4780);
// EXTERNAL MODULE: ./components/MetaHeader.jsx
var MetaHeader = __webpack_require__(2158);
;// CONCATENATED MODULE: ./pages/index.js










const getStaticProps = async ()=>{
    let home_data = await (0,pages_data/* getHomepageData */.r_)();
    const header_data = await (0,pages_data/* getHeaderFooterData */.WV)();
    return {
        props: {
            ...home_data,
            ...header_data
        },
        revalidate: 1
    };
};
const Home = ({ featuredPost , headerTitles , tickingHeader , leftTrending , rightTrending , body , footerPost , footerContacts ,  })=>{
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        className: (Home_module_default()).container,
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx(MetaHeader/* default */.Z, {
                title: "Ticking Bomb"
            }),
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)(PageLayout/* default */.Z, {
                className: "lg:px-14",
                tickingHeader: tickingHeader,
                footerPost: footerPost,
                footerContacts: footerContacts,
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("main", {
                        className: "flex flex-col items-center",
                        children: featuredPost && /*#__PURE__*/ jsx_runtime_.jsx(FeaturedPost/* default */.Z, {
                            post: featuredPost
                        })
                    }),
                    /*#__PURE__*/ jsx_runtime_.jsx(components_TrendingNews, {
                        title: headerTitles?.trending_title,
                        leftTrending: leftTrending,
                        rightTrending: rightTrending
                    }),
                    body && /*#__PURE__*/ jsx_runtime_.jsx(components_BodySection, {
                        title: headerTitles?.body_title,
                        body: body
                    })
                ]
            })
        ]
    });
};
Home.defaultProps = {
    featured_post: {},
    headerTitles: {
        trending_title: "",
        body_title: ""
    }
};
/* harmony default export */ const pages = (Home);


/***/ }),

/***/ 8768:
/***/ ((module) => {

module.exports = require("@heroicons/react/outline");

/***/ }),

/***/ 2796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 4957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 4014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 5843:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config.js");

/***/ }),

/***/ 8524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 8020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 4406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 4964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 3938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 9565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 4365:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-middleware-regex.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 1292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 6052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 4226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 5052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 9232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 4780:
/***/ ((module) => {

module.exports = require("next/script");

/***/ }),

/***/ 6689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 855:
/***/ ((module) => {

module.exports = require("xml2js");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [505,61,281,158,517], () => (__webpack_exec__(2301)));
module.exports = __webpack_exports__;

})();