"use strict";
(() => {
var exports = {};
exports.id = 106;
exports.ids = [106];
exports.modules = {

/***/ 2371:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ exclusive),
  "getServerSideProps": () => (/* binding */ getServerSideProps)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
// EXTERNAL MODULE: ./styles/Home.module.css
var Home_module = __webpack_require__(9399);
var Home_module_default = /*#__PURE__*/__webpack_require__.n(Home_module);
// EXTERNAL MODULE: ./components/PageLayout.js + 20 modules
var PageLayout = __webpack_require__(1220);
// EXTERNAL MODULE: ./node_modules/next/link.js
var next_link = __webpack_require__(1664);
var link_default = /*#__PURE__*/__webpack_require__.n(next_link);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(6689);
;// CONCATENATED MODULE: ./components/ExclusivePost.js



const ExclusivePost = ({ post  })=>{
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: "flex flex-row text-left justify-between gap-10 ",
                children: /*#__PURE__*/ jsx_runtime_.jsx("div", {
                    className: "flex flex-col gap-5 justify-between",
                    children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                        className: "flex flex-col gap-2",
                        children: [
                            /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                className: "text-5xl font-bold underline",
                                children: post?.date
                            }),
                            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                className: "flex flex-col gap-5",
                                children: post?.items?.map((item, index)=>/*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                        className: "flex flex-col",
                                        children: [
                                            /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                                href: `/exclusive/${item?.attributes?.slug}`,
                                                children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                    className: "text-2xl font-bold cursor-pointer hover:underline",
                                                    children: item?.attributes?.title
                                                })
                                            }),
                                            /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                                className: "text-base hover:underline ",
                                                href: item?.attributes?.author_url + "?utm_source=tickingbomb.com",
                                                target: "_blank",
                                                rel: "noopener noreferrer",
                                                children: item?.attributes?.author
                                            })
                                        ]
                                    }, index)
                                )
                            })
                        ]
                    })
                })
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: "w-full h-0.5 bg-gray-200"
            })
        ]
    });
};
/* harmony default export */ const components_ExclusivePost = (ExclusivePost);

;// CONCATENATED MODULE: ./components/Pagination.js



const Pagination = ({ pagination  })=>{
    const pagesCount = pagination.pageCount // 100/10
    ;
    if (pagesCount === 1) return null;
    const pages = Array.from({
        length: pagesCount
    }, (_, i)=>i + 1
    );
    return /*#__PURE__*/ jsx_runtime_.jsx("div", {
        children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("ul", {
            className: (Home_module_default()).pagination,
            children: [
                pagination.page > 1 && /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                    href: `/exclusive?page=${pagination.page - 1}`,
                    children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                        className: `${(Home_module_default()).pageItem} text-lg`,
                        children: "\xab"
                    })
                }),
                pagination.pageCount > 10 ? /*#__PURE__*/ (0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
                    children: [
                        pagination.page > 4 && /*#__PURE__*/ (0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                    href: `/exclusive?page=1`,
                                    children: /*#__PURE__*/ jsx_runtime_.jsx("li", {
                                        className: 1 === pagination.page ? (Home_module_default()).pageItemActive : (Home_module_default()).pageItem,
                                        children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                            className: (Home_module_default()).pageLink,
                                            children: "1"
                                        })
                                    })
                                }, 1),
                                /*#__PURE__*/ jsx_runtime_.jsx("li", {
                                    className: (Home_module_default()).pageItem,
                                    children: /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                        className: (Home_module_default()).pageLink,
                                        children: "..."
                                    })
                                })
                            ]
                        }),
                        pagination.page <= 4 ? pages.slice(0, pagination.page === 4 ? 6 : 4).map((page)=>/*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                href: `/exclusive?page=${page}`,
                                className: page === pagination.page ? (Home_module_default()).pageItemActive : (Home_module_default()).pageItem,
                                children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                    className: (Home_module_default()).pageLink,
                                    children: page
                                })
                            }, page)
                        ) : pagination.page > pagination.pageCount - 4 ? pages.slice(-4).map((page)=>/*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                href: `/exclusive?page=${page}`,
                                children: /*#__PURE__*/ jsx_runtime_.jsx("li", {
                                    className: page === pagination.page ? (Home_module_default()).pageItemActive : (Home_module_default()).pageItem,
                                    children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                        className: (Home_module_default()).pageLink,
                                        children: page
                                    })
                                })
                            }, page)
                        ) : /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
                            children: [
                                pagination.page - 2,
                                pagination.page - 1,
                                pagination.page,
                                pagination.page + 1,
                                pagination.page + 2, 
                            ].map((page)=>/*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                    href: `/exclusive?page=${page}`,
                                    children: /*#__PURE__*/ jsx_runtime_.jsx("li", {
                                        className: page === pagination.page ? (Home_module_default()).pageItemActive : (Home_module_default()).pageItem,
                                        children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                            className: (Home_module_default()).pageLink,
                                            children: page
                                        })
                                    })
                                }, page)
                            )
                        }),
                        (pagination.page <= 4 || pagination.page < pages.length - 3) && /*#__PURE__*/ (0,jsx_runtime_.jsxs)(jsx_runtime_.Fragment, {
                            children: [
                                /*#__PURE__*/ jsx_runtime_.jsx("li", {
                                    className: (Home_module_default()).pageItem,
                                    children: /*#__PURE__*/ jsx_runtime_.jsx("span", {
                                        className: (Home_module_default()).pageLink,
                                        children: "..."
                                    })
                                }),
                                /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                                    href: `/exclusive?page=${pagination.pageCount}`,
                                    children: /*#__PURE__*/ jsx_runtime_.jsx("li", {
                                        className: pages.length === pagination.page ? (Home_module_default()).pageItemActive : (Home_module_default()).pageItem,
                                        children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                            className: (Home_module_default()).pageLink,
                                            children: pages.length
                                        })
                                    })
                                }, pages.length)
                            ]
                        })
                    ]
                }) : pages.map((page)=>/*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                        href: `/exclusive?page=${page}`,
                        children: /*#__PURE__*/ jsx_runtime_.jsx("li", {
                            className: page === pagination.page ? (Home_module_default()).pageItemActive : (Home_module_default()).pageItem,
                            children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                                className: (Home_module_default()).pageLink,
                                children: page
                            })
                        })
                    }, page)
                ),
                pagination.page < pagesCount && /*#__PURE__*/ jsx_runtime_.jsx((link_default()), {
                    href: `/exclusive?page=${pagination.page + 1}`,
                    children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                        className: `${(Home_module_default()).pageItem} text-lg`,
                        children: "\xbb"
                    })
                })
            ]
        })
    });
};
/* harmony default export */ const components_Pagination = (Pagination);

// EXTERNAL MODULE: ./utils/pages.data.js
var pages_data = __webpack_require__(7324);
// EXTERNAL MODULE: ./components/MetaHeader.jsx
var MetaHeader = __webpack_require__(2158);
;// CONCATENATED MODULE: ./pages/exclusive/index.js







const getServerSideProps = async ({ query  })=>{
    const exclusive = await (0,pages_data/* getExclusiveData */.DN)(query.page ?? 1);
    const configData = await (0,pages_data/* getConfigData */.c$)();
    const header_data = await (0,pages_data/* getHeaderFooterData */.WV)();
    return {
        props: {
            exclusive: exclusive ?? [],
            configData: configData.data ?? {},
            meta: exclusive?.meta ?? {},
            ...header_data
        }
    };
};
const Exclusive = ({ exclusive , configData , tickingHeader , footerPost , footerContacts ,  })=>{
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        className: (Home_module_default()).container,
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx(MetaHeader/* default */.Z, {
                title: "Exclusive Blogs | Ticking Bomb"
            }),
            /*#__PURE__*/ jsx_runtime_.jsx(PageLayout/* default */.Z, {
                className: "lg:px-14",
                pageTitle: "Exclusive",
                tickingHeader: tickingHeader,
                configUrl: configData?.attributes?.exclusive_logo?.data?.attributes?.url,
                footerPost: footerPost,
                footerContacts: footerContacts,
                children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("section", {
                    className: "flex flex-col lg:flex-row justify-between w-full mt-7",
                    children: [
                        /*#__PURE__*/ jsx_runtime_.jsx("div", {
                            className: "w-full lg:w-36 p-6 bg-template-bg-grey flex justify-center items-center text-gray-600",
                            children: "Ad"
                        }),
                        /*#__PURE__*/ jsx_runtime_.jsx("div", {
                            className: "flex-1 text-center p-5",
                            children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                                className: "flex flex-col gap-5",
                                children: [
                                    /*#__PURE__*/ jsx_runtime_.jsx("div", {
                                        className: "flex flex-col gap-10",
                                        children: exclusive?.map((item)=>/*#__PURE__*/ jsx_runtime_.jsx(components_ExclusivePost, {
                                                post: item
                                            }, item.id)
                                        )
                                    }),
                                    exclusive?.meta?.pagination && exclusive.meta.pagination.pageCount > 1 && /*#__PURE__*/ jsx_runtime_.jsx(components_Pagination, {
                                        pagination: exclusive.meta.pagination
                                    })
                                ]
                            })
                        }),
                        /*#__PURE__*/ jsx_runtime_.jsx("div", {
                            className: "w-full lg:w-36 p-6 bg-template-bg-grey flex justify-center items-center text-gray-600",
                            children: "Ad"
                        })
                    ]
                })
            })
        ]
    });
};
/* harmony default export */ const exclusive = (Exclusive);


/***/ }),

/***/ 8768:
/***/ ((module) => {

module.exports = require("@heroicons/react/outline");

/***/ }),

/***/ 2796:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head-manager-context.js");

/***/ }),

/***/ 4957:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/head.js");

/***/ }),

/***/ 4014:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/i18n/normalize-locale-path.js");

/***/ }),

/***/ 744:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config-context.js");

/***/ }),

/***/ 5843:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/image-config.js");

/***/ }),

/***/ 8524:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/is-plain-object.js");

/***/ }),

/***/ 8020:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/mitt.js");

/***/ }),

/***/ 4406:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/page-path/denormalize-page-path.js");

/***/ }),

/***/ 4964:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router-context.js");

/***/ }),

/***/ 3938:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/format-url.js");

/***/ }),

/***/ 9565:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-asset-path-from-route.js");

/***/ }),

/***/ 4365:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/get-middleware-regex.js");

/***/ }),

/***/ 1428:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/is-dynamic.js");

/***/ }),

/***/ 1292:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/parse-relative-url.js");

/***/ }),

/***/ 979:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/querystring.js");

/***/ }),

/***/ 6052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/resolve-rewrites.js");

/***/ }),

/***/ 4226:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-matcher.js");

/***/ }),

/***/ 5052:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/router/utils/route-regex.js");

/***/ }),

/***/ 9232:
/***/ ((module) => {

module.exports = require("next/dist/shared/lib/utils.js");

/***/ }),

/***/ 968:
/***/ ((module) => {

module.exports = require("next/head");

/***/ }),

/***/ 4780:
/***/ ((module) => {

module.exports = require("next/script");

/***/ }),

/***/ 6689:
/***/ ((module) => {

module.exports = require("react");

/***/ }),

/***/ 997:
/***/ ((module) => {

module.exports = require("react/jsx-runtime");

/***/ }),

/***/ 855:
/***/ ((module) => {

module.exports = require("xml2js");

/***/ })

};
;

// load runtime
var __webpack_require__ = require("../webpack-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = __webpack_require__.X(0, [505,61,281,158], () => (__webpack_exec__(2371)));
module.exports = __webpack_exports__;

})();