"use strict";
(() => {
var exports = {};
exports.id = 439;
exports.ids = [439];
exports.modules = {

/***/ 1653:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

// ESM COMPAT FLAG
__webpack_require__.r(__webpack_exports__);

// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "default": () => (/* binding */ handler)
});

;// CONCATENATED MODULE: ./utils/pages.constants.js
const SOCIAL_TYPE = {
    Twitter: "Twitter",
    YouTube: "YouTube"
};
const NAVBAR_ITEMS = [
    {
        title: "Home",
        navLink: "/"
    },
    {
        title: "Exclusive",
        navLink: "/exclusive"
    },
    {
        title: "Carpet Bomb",
        navLink: "/carpet-bomb"
    },
    {
        title: "Bookmarks",
        navLink: "/bookmarks"
    },
    {
        title: "Tools",
        navLink: "/tools"
    }
];
const POST_COMPONENT_TYPE = {
    DOCUMENT: "post-type.document",
    TWITTER: "post-type.twitter",
    YOUTUBE: "post-type.youtube",
    TEXT: "post-type.text",
    LONG_TEXT: "post-type.long-text",
    RUMBLE: "post-type.rumble",
    IMAGE: "post-type.image"
};
const API_URL = "https://admin.tickingbomb.com";
const BACKEND_URL = (/* unused pure expression or super */ null && ("https://admin.tickingbomb.com" || 0));
const PATHS = {
    home: "/",
    about: "/about",
    contact: "/contact",
    resources: "/resources",
    topics: "/topics"
};

;// CONCATENATED MODULE: ./pages/api/message.js
// Next.js API route support: https://nextjs.org/docs/api-routes/introduction

async function handler(req, res) {
    if (req.method !== "POST") return res.status(400).json({
        error: {
            message: "Invalid Request"
        }
    });
    const data = await (await fetch(`${API_URL}/api/messages`, {
        method: "POST",
        headers: {
            "Content-Type": "application/json"
        },
        body: JSON.stringify(req.body)
    })).json();
    res.status(200).json(data);
};


/***/ })

};
;

// load runtime
var __webpack_require__ = require("../../webpack-api-runtime.js");
__webpack_require__.C(exports);
var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
var __webpack_exports__ = (__webpack_exec__(1653));
module.exports = __webpack_exports__;

})();