"use strict";
exports.id = 517;
exports.ids = [517];
exports.modules = {

/***/ 3517:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5341);
/* harmony import */ var _Document__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1812);
/* harmony import */ var _RumbleFrame__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(6981);
/* harmony import */ var _TextLink__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4726);
/* harmony import */ var _Tweet__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(1972);
/* harmony import */ var _YoutubeFrame__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(9893);







const Post = ({ post , leftAlignment  })=>{
    const postTypeRendering = (type)=>{
        switch(type.__component){
            case _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .POST_COMPONENT_TYPE.TEXT */ .HH.TEXT:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("li", {
                    className: "mb-1 list-none",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_TextLink__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
                        data: type
                    })
                });
            case _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .POST_COMPONENT_TYPE.DOCUMENT */ .HH.DOCUMENT:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("li", {
                    className: "mb-1 list-none",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_Document__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
                        data: type
                    })
                });
            case _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .POST_COMPONENT_TYPE.TWITTER */ .HH.TWITTER:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_Tweet__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
                    data: type
                });
            case _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .POST_COMPONENT_TYPE.YOUTUBE */ .HH.YOUTUBE:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_YoutubeFrame__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
                    data: type
                });
            case _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .POST_COMPONENT_TYPE.RUMBLE */ .HH.RUMBLE:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx(_RumbleFrame__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
                    data: type
                });
            case _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .POST_COMPONENT_TYPE.IMAGE */ .HH.IMAGE:
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("a", {
                    href: type.img_url + "?utm_source=tickingbomb.com",
                    target: "_blank",
                    rel: "noopener noreferrer",
                    children: /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("img", {
                        loading: "lazy",
                        className: "object-contain max-w-full",
                        style: {
                            width: type.img_size + "rem"
                        },
                        src: type.img_source ? type.img_source : type.image.url || _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .BACKEND_URL */ .z0 + type?.image.data?.attributes?.url,
                        alt: "alternativeText",
                        title: type.scroll_text
                    })
                });
            case _utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .POST_COMPONENT_TYPE.LONG_TEXT */ .HH.LONG_TEXT:
                let content = type.content.replace(/src="/g, `src=\"${_utils_pages_constants__WEBPACK_IMPORTED_MODULE_1__/* .BACKEND_URL */ .z0}`).replace(/&lt;hr&gt;/g, "<hr>");
                return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                    dangerouslySetInnerHTML: {
                        __html: content
                    },
                    className: "prose lg:prose-xl"
                });
            default:
                break;
        }
    };
    return /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
        className: "px-2",
        children: [
            /*#__PURE__*/ (0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsxs)("div", {
                className: `mt-1 flex flex-col gap-2 ${leftAlignment ? "items-start" : "items-start lg:items-end"}`,
                children: [
                    post.show_title && /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("h2", {
                        className: "text-xl font-bold uppercase",
                        children: post.post_title
                    }),
                    post.type?.map((type)=>{
                        return /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("div", {
                            className: "w-full",
                            children: postTypeRendering(type)
                        }, type.__component + type.id);
                    })
                ]
            }),
            /*#__PURE__*/ react_jsx_runtime__WEBPACK_IMPORTED_MODULE_0__.jsx("hr", {
                className: "mt-3"
            })
        ]
    });
};
Post.defaultProps = {
    post: {},
    leftAlignment: true
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Post);


/***/ })

};
;