"use strict";
exports.id = 501;
exports.ids = [501];
exports.modules = {

/***/ 9501:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {


// EXPORTS
__webpack_require__.d(__webpack_exports__, {
  "Z": () => (/* binding */ ThreeLevelNesting)
});

// EXTERNAL MODULE: external "react/jsx-runtime"
var jsx_runtime_ = __webpack_require__(997);
// EXTERNAL MODULE: external "react"
var external_react_ = __webpack_require__(6689);
var external_react_default = /*#__PURE__*/__webpack_require__.n(external_react_);
;// CONCATENATED MODULE: ./components/FiltersSection.js


const FiltersSection = ({ topics , selectedFilter , selectedSubFilter , handleFilterSelection , handleSubFilterSelection  })=>{
    return /*#__PURE__*/ jsx_runtime_.jsx(jsx_runtime_.Fragment, {
        children: /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
            className: "flex flex-row",
            children: [
                /*#__PURE__*/ jsx_runtime_.jsx("div", {
                    className: "bg-template-bg-grey w-full lg:w-52 text-left",
                    children: /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        children: topics?.map((topic, index)=>/*#__PURE__*/ jsx_runtime_.jsx("button", {
                                value: index,
                                className: `list-none p-1 cursor-pointer text-lg hover:bg-template-input-border w-full text-left uppercase  ${selectedFilter == index ? "bg-black text-white" : ""}`,
                                onClick: handleFilterSelection,
                                children: topic.attributes.title
                            }, topic.id)
                        )
                    })
                }),
                selectedFilter != -1 && /*#__PURE__*/ jsx_runtime_.jsx("div", {
                    className: "bg-template-bg-grey w-full lg:w-52 text-left",
                    children: /*#__PURE__*/ jsx_runtime_.jsx("div", {
                        children: topics[selectedFilter]?.attributes?.level_2?.map((topic, index)=>/*#__PURE__*/ jsx_runtime_.jsx("button", {
                                value: topic.id,
                                className: `list-none p-1 cursor-pointer text-lg hover:bg-template-input-border w-full text-left uppercase ${selectedSubFilter == topic.id ? "bg-black text-white" : ""}`,
                                onClick: handleSubFilterSelection,
                                children: topic.title
                            }, topic.id)
                        )
                    })
                })
            ]
        })
    });
};
/* harmony default export */ const components_FiltersSection = (FiltersSection);

// EXTERNAL MODULE: ./utils/pages.constants.js
var pages_constants = __webpack_require__(5341);
// EXTERNAL MODULE: ./utils/helpers.js
var helpers = __webpack_require__(7278);
;// CONCATENATED MODULE: ./components/RssFeed.js




const RssFeed = ({ rssData , logo , count , title , logo_size  })=>{
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        className: "col-span-1 flex flex-col items-center gap-5",
        children: [
            logo?.data ? /*#__PURE__*/ jsx_runtime_.jsx("a", {
                href: rssData?.link[0] + "?utm_source=tickingbomb.com",
                target: "_blank",
                rel: "noreferrer",
                children: /*#__PURE__*/ jsx_runtime_.jsx("img", {
                    src: pages_constants/* BACKEND_URL */.z0 + logo?.data?.attributes?.url,
                    style: {
                        width: logo_size + "rem"
                    },
                    alt: "line",
                    className: "text-center object-cover w-24"
                })
            }) : rssData?.title[0] && /*#__PURE__*/ jsx_runtime_.jsx("a", {
                href: rssData?.link[0] + "?utm_source=tickingbomb.com",
                target: "_blank",
                rel: "noreferrer",
                children: /*#__PURE__*/ jsx_runtime_.jsx("h2", {
                    className: "text-xl py-3 font-bold uppercase underline",
                    children: title
                })
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: "flex flex-col gap-5",
                children: rssData?.item?.map((child, index)=>index < count && /*#__PURE__*/ (0,jsx_runtime_.jsxs)("a", {
                        className: "hover:underline visited:!text-[#878787]",
                        href: child.link[0] + "?utm_source=tickingbomb.com",
                        target: "_blank",
                        rel: "noopener noreferrer",
                        children: [
                            /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                className: "text-xl text-left ",
                                children: child?.title[0]
                            }),
                            /*#__PURE__*/ jsx_runtime_.jsx("p", {
                                className: "text-left",
                                children: (0,helpers/* formatDate */.p6)(child?.pubDate)
                            })
                        ]
                    }, index)
                )
            })
        ]
    });
};
/* harmony default export */ const components_RssFeed = (RssFeed);

;// CONCATENATED MODULE: ./components/ThreeLevelNesting.js





function ThreeLevelNesting({ topics , filterType  }) {
    const { 0: selectedFilter , 1: setSelectedFilter  } = (0,external_react_.useState)(0);
    const { 0: selectedSubFilter , 1: setSelectedSubFilter  } = (0,external_react_.useState)(null);
    const handleFilterSelection = (e)=>{
        setSelectedFilter(e.target.value);
        setSelectedSubFilter(null);
    };
    const handleSubFilterSelection = (e)=>{
        setSelectedSubFilter(e.target.value);
    };
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("section", {
        className: "flex flex-col lg:flex-row justify-between w-full mt-7",
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx(components_FiltersSection, {
                topics: topics,
                selectedFilter: selectedFilter,
                selectedSubFilter: selectedSubFilter,
                handleFilterSelection: handleFilterSelection,
                handleSubFilterSelection: handleSubFilterSelection
            }),
            /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
                className: "flex-1 text-center p-5",
                children: [
                    /*#__PURE__*/ jsx_runtime_.jsx("h2", {
                        className: "text-4xl pb-3 font-bold",
                        children: topics[selectedFilter]?.attributes.title
                    }),
                    topics[selectedFilter] && topics[selectedFilter]?.attributes?.level_2?.map((level_2)=>(selectedSubFilter == level_2.id || selectedSubFilter == null) && /*#__PURE__*/ jsx_runtime_.jsx("div", {
                            className: "mb-4",
                            children: filterType == 2 ? /*#__PURE__*/ jsx_runtime_.jsx(Level3DoubleSide, {
                                title: level_2.title,
                                level3: level_2.links || []
                            }) : /*#__PURE__*/ jsx_runtime_.jsx(Level3, {
                                title: level_2.title,
                                level3: level_2.links || []
                            })
                        }, level_2.id)
                    )
                ]
            })
        ]
    });
};
function Level3({ title , level3  }) {
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("h2", {
                className: "text-xl py-1 uppercase font-bold bg-template-black text-white",
                children: title
            }),
            level3.map((section)=>section.bold ? /*#__PURE__*/ jsx_runtime_.jsx((external_react_default()).Fragment, {
                    children: section?.logo?.data ? /*#__PURE__*/ jsx_runtime_.jsx("img", {
                        src: pages_constants/* BACKEND_URL */.z0 + section?.logo?.data.attributes.url,
                        alt: "line",
                        className: "text-center"
                    }) : /*#__PURE__*/ jsx_runtime_.jsx("h2", {
                        className: "text-xl py-3 font-bold uppercase underline",
                        children: section.title
                    }, section.id)
                }, section.id) : /*#__PURE__*/ jsx_runtime_.jsx("div", {
                    children: /*#__PURE__*/ jsx_runtime_.jsx("a", {
                        href: section.url + "?utm_source=tickingbomb.com",
                        target: section.new_tab ? "_blank" : "_self",
                        rel: "noopener noreferrer",
                        className: "pb-1 text-lg hover:underline",
                        children: section.title
                    })
                }, section.id)
            )
        ]
    });
}
function Level3DoubleSide({ title , level3  }) {
    return /*#__PURE__*/ (0,jsx_runtime_.jsxs)("div", {
        className: "flex flex-col gap-5",
        children: [
            /*#__PURE__*/ jsx_runtime_.jsx("h2", {
                className: "text-xl py-1 uppercase font-bold bg-template-black text-white",
                children: title
            }),
            /*#__PURE__*/ jsx_runtime_.jsx("div", {
                className: "grid grid-cols-2 gap-10",
                children: level3.map((section, index)=>{
                    return /*#__PURE__*/ jsx_runtime_.jsx(components_RssFeed, {
                        count: section?.count,
                        title: section?.title,
                        logo_size: section?.logo_size,
                        rssData: section?.rss?.rss?.channel[0] || null,
                        logo: section?.logo
                    }, index);
                })
            })
        ]
    });
}


/***/ })

};
;